/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structurepiece.silverdungeon;

import com.aetherteam.aether.world.structurepiece.silverdungeon.SilverDungeonRoom;
import com.aetherteam.aether.world.structurepiece.silverdungeon.SilverFloorPiece;
import com.aetherteam.aether.world.structurepiece.silverdungeon.SilverTemplePiece;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class SilverDungeonBuilder {
    private static final int CHEST_ROOM = 1;
    private static final int STAIRS = 2;
    private static final int FINAL_STAIRS = 4;
    private static final int STAIRS_MIDDLE = 8;
    private static final int STAIRS_TOP = 16;
    private static final int NORTH_DOOR = 32;
    private static final int WEST_DOOR = 64;
    private static final int VISITED = 128;
    private final RandomSource random;
    private final int[][][] grid;
    private final int width;
    private final int height;
    private final int length;

    public SilverDungeonBuilder(RandomSource random, int x, int y, int z) {
        this.random = random;
        this.grid = new int[x][y][z];
        this.width = x;
        this.height = y;
        this.length = z;
        this.populateGrid();
    }

    private void populateGrid() {
        int finalStairsX = this.random.m_188503_(this.width);
        this.grid[finalStairsX][0][0] = 4;
        this.grid[finalStairsX][1][0] = 8;
        this.grid[finalStairsX][2][0] = 16;
        int firstStairsX = this.random.m_188503_(this.width);
        this.grid[firstStairsX][0][1] = 2;
        this.grid[firstStairsX][1][1] = 16;
        int secondStairsX = this.random.m_188503_(this.width);
        this.grid[secondStairsX][1][2] = 2;
        this.grid[secondStairsX][2][2] = 16;
        for (int y = 0; y < this.height; ++y) {
            this.traverseRooms(1, y, 1, 0);
            for (int z = 0; z < this.length; ++z) {
                for (int x = 0; x < this.width; ++x) {
                    if ((this.grid[x][y][z] & 0x1F) != 0 || this.random.m_188503_(3) == 0) continue;
                    int[] nArray = this.grid[x][y];
                    int n = z;
                    nArray[n] = nArray[n] | 1;
                }
            }
        }
    }

    private boolean traverseRooms(int x, int y, int z, int typesToAvoid) {
        if (x < 0 || x >= this.width || z < 0 || z >= this.length) {
            return false;
        }
        int room = this.grid[x][y][z];
        if ((room & typesToAvoid) > 0) {
            return false;
        }
        if ((room & 0x80) == 128) {
            return this.random.m_188503_(3) == 0;
        }
        int[] nArray = this.grid[x][y];
        int n = z;
        nArray[n] = nArray[n] | 0x80;
        int blacklist = this.setNeighborBlacklist(room);
        ArrayList directions = new ArrayList(4);
        Collections.addAll(directions, Direction.NORTH, Direction.WEST, Direction.SOUTH, Direction.EAST);
        block6: for (int i = directions.size(); i > 0; --i) {
            int index = this.random.m_188503_(i);
            switch ((Direction)directions.remove(index)) {
                case NORTH: {
                    if (!this.traverseRooms(x, y, z - 1, blacklist)) continue block6;
                    int[] nArray2 = this.grid[x][y];
                    int n2 = z;
                    nArray2[n2] = nArray2[n2] | 0x20;
                    continue block6;
                }
                case SOUTH: {
                    if (!this.traverseRooms(x, y, z + 1, blacklist)) continue block6;
                    int[] nArray3 = this.grid[x][y];
                    int n3 = z + 1;
                    nArray3[n3] = nArray3[n3] | 0x20;
                    continue block6;
                }
                case WEST: {
                    if (!this.traverseRooms(x - 1, y, z, blacklist)) continue block6;
                    int[] nArray4 = this.grid[x][y];
                    int n4 = z;
                    nArray4[n4] = nArray4[n4] | 0x40;
                    continue block6;
                }
                case EAST: {
                    if (!this.traverseRooms(x + 1, y, z, blacklist)) continue block6;
                    int[] nArray5 = this.grid[x + 1][y];
                    int n5 = z;
                    nArray5[n5] = nArray5[n5] | 0x40;
                }
            }
        }
        return true;
    }

    private int setNeighborBlacklist(int roomType) {
        int blacklist = 12;
        if ((roomType & 0x10) == 16) {
            blacklist |= 2;
        }
        if ((roomType & 2) == 2) {
            blacklist |= 0x10;
        }
        return blacklist;
    }

    public void assembleDungeon(StructurePiecesBuilder builder, StructureTemplateManager templateManager, BlockPos startPos, Rotation rotation, Direction direction) {
        startPos = startPos.m_7918_(direction.m_122431_() * 5 - direction.m_122429_(), 5, -direction.m_122429_() * 5 - direction.m_122431_());
        BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
        Rotation sideways = rotation.m_55952_(Rotation.CLOCKWISE_90);
        for (int y = this.height - 1; y >= 0; --y) {
            offset.m_142448_(startPos.m_123342_() + y * 5);
            for (int z = 0; z < this.length; ++z) {
                for (int x = 0; x < this.width; ++x) {
                    int xOffset = startPos.m_123341_() + direction.m_122431_() * x * 7 + direction.m_122429_() * z * 7;
                    int zOffset = startPos.m_123343_() + direction.m_122431_() * z * 7 - direction.m_122429_() * x * 7;
                    offset.m_122178_(xOffset, offset.m_123342_(), zOffset);
                    int room = this.grid[x][y][z];
                    builder.m_142679_((StructurePiece)new SilverFloorPiece(templateManager, "floor", offset.m_7918_(direction.m_122429_() + direction.m_122431_(), -1, direction.m_122431_() - direction.m_122429_()), rotation));
                    builder.m_142679_((StructurePiece)new SilverTemplePiece(templateManager, (room & 0x20) == 32 ? "door" : "wall", offset.m_7918_(direction.m_122431_(), 0, -direction.m_122429_()), rotation));
                    builder.m_142679_((StructurePiece)new SilverTemplePiece(templateManager, (room & 0x40) == 64 ? "door" : "wall", offset.m_121945_(direction), sideways));
                    if ((room & 4) == 4) {
                        builder.m_142679_((StructurePiece)new SilverDungeonRoom(templateManager, "tall_staircase", offset.m_7918_(2, 0, 2), rotation));
                        builder.m_142679_((StructurePiece)new SilverTemplePiece(templateManager, "boss_door", offset.m_7918_(direction.m_122431_() * 3, 0, -direction.m_122429_() * 3), rotation));
                        continue;
                    }
                    if ((room & 2) == 2) {
                        builder.m_142679_((StructurePiece)new SilverDungeonRoom(templateManager, "staircase", offset.m_7918_(2, 0, 2), rotation));
                        continue;
                    }
                    if ((room & 1) != 1) continue;
                    builder.m_142679_((StructurePiece)new SilverDungeonRoom(templateManager, "chest_room", offset.m_7918_(3, 0, 3), rotation));
                }
            }
        }
    }
}

